'<ADbasic Header, Headerversion 001.001>
' Process_Number                 = 1
' Initial_Processdelay           = 400
' Eventsource                    = Timer
' Control_long_Delays_for_Stop   = No
' Priority                       = High
' Version                        = 1
' ADbasic_Version                = 6.2.0
' Optimize                       = No
' Stacksize                      = 1000
' Info_Last_Save                 = TUD207942  DASTUD\joeridebruijck
'<Header End>
'electromigration_joeri.bas:
'
'-------------------Process outline-----------------------
'event loop:
'   1. set voltage output 1 to start voltage + count
'   2. read adc value of input 1 and convert to current
'   3. enter 'first_loop' (only at start of ramp) or 'main_loop'
'     - first_loop:
'       4. check if resistance > cut-off resistance (FPAR_1)
'       5. if yes: set output voltage to zero and exit program
'
'     - main loop:
'       4. check if one of the following conditions is met 
'         - cut-off voltage (PAR_2) is reached 
'         - selected cut-off quantity (PAR_7) exceeds given value (FPAR_2)
'       5. if yes: - set output voltage and count to zero 
'                  - write final voltage and resistance in PAR_3 and FPAR_3 
'                  - Return to 1. (enter first loop)
'          if no:  - increase count by 1 
'                  - Return to 1. (enter main loop)
'
'------------------Global variables----------------------
'Inputs:
'   integers:
'PAR_1 = start voltage (native units)
'PAR_2 = cut-off voltage (native units)
'PAR_4 = delay time between DAC output and ADC read (in units of 0.1us)
'PAR_5 = steps back in voltage after end of ramp (native units) 
'        (note: PAR_5 = 0 --> step back to start voltage)
'PAR_6 = number of times adc reading is averaged
'PAR_7 = cut-off criterion (0 = |R-R0|/R, 1 = |R-R0|/(R*R0), 2 = |dR/dt|, 3 = (1/R)|dR/dt|
'PAR_8 = single ramp process (1 = single ramp process (stop at cutoff), 0 = continuous (only stop at target R))
'   floats:
'FPAR_1 = target resistance (Ohm)
'FPAR_2 = maximum change in resistance relative to resistance at start voltage (>0.0)
'   arrays float:
'DATA_1 = conversion table to current (A)

'Outputs:
'   integers:
'PAR_3 = voltage last finished sweep (native units)
'   floats:
'FPAR_3 = resistance last finished sweep (Ohm)
'-------------------------------------------------------

DIM DATA_1[65536] as float 'lookup table for current in A
DIM v, adc_value, count, first_loop, i as integer
DIM first_r, r, old_r, cutoff as float

INIT:
  
  count = 0
  first_loop = 1
  adc_value = 0
  
  SET_MUX(0010000000b)    'ADC 1, gain 4
  sleep(PAR_4)
  DAC(1, PAR_1)           'set voltage on output 1
  sleep(PAR_4)
  
EVENT:
  
  v = PAR_1 + count 
  
  DAC(1, v)               'set voltage on output 1
  sleep(PAR_4)
  FOR i = 1 TO PAR_6
    START_CONV(1)           'start analog to digital conversion
    WAIT_EOC(1)             'wait for conversion to be finished
    adc_value = READADC(1) + adc_value  'read adc value of input 1
  NEXT i
  
  IF (i > 1) THEN
    adc_value = Round(adc_value/PAR_6)
  ENDIF
  
  r = (v-32768)/(DATA_1[adc_value]*3276.8)
  adc_value = 0 'clear for next loop
  
  IF (first_loop = 1) THEN
    first_r = r
    old_r = r
    IF (r > FPAR_1) THEN
      END
    ELSE
      first_loop = 0
    ENDIF
  ELSE
    SelectCase PAR_7 'select cut-off criterion
      Case 0
        cutoff = AbsF(r-first_r)/first_r
      Case 1
        cutoff = AbsF(r-first_r)/(r*first_r)
      Case 2
        cutoff = AbsF(r-old_r)
        old_r = r
      Case 3
        cutoff = AbsF(r-old_r)/r
        old_r = r        
    EndSelect
     
    IF((v > PAR_2) OR (cutoff > FPAR_2)) THEN 'check cut-off criteria
      IF (PAR_8 = 1) THEN 'single ramp (1) or continuous (0) process
        END
      ELSE
        IF (PAR_5 > 0) THEN 'step back voltage (if 0, step back to start voltage)
          count = count - PAR_5
          IF (count < 0) THEN
            count = 0
          ENDIF
        ELSE
          count = 0
        ENDIF
        DAC(1, PAR_1 + count)
        PAR_3 = v
        FPAR_3 = r
        first_loop = 1
      ENDIF  
    ELSE
      count = count + 1
    ENDIF
  ENDIF
  
FINISH:
  DAC(1,32768)
  PAR_3 = v
  FPAR_3 = r
